File: /quick-reference/quickstart-saas-os.md

# Quickstart — SaaS OS Free Edition (10–20 min)

This is the fastest path to start using SaaS OS Free Edition.

No advanced architecture.
No flows.
No deep system rules.

Just a clean and correct setup using:
- Tokens
- Button contract
- Input contract
- Basic Cursor usage

---

## Outcome

By the end, you will have:

- A working Next.js app
- SaaS OS tokens applied globally
- A simple landing page using Button + Input
- Contract-aware code generation

---

## 0) Create a Next.js App (2–5 min)

Create a new project:

npx create-next-app@latest my-app
cd my-app
npm run dev

Confirm:
- The app runs
- `package.json` exists
- `/` renders

Do not copy SaaS OS files before scaffolding.

Scaffold first.

---

## 1) Add SaaS OS Free to Your Project (2 min)

Copy the folder:

SaaS-OS-Free-v1.0/

into your project root.

Example:

my-app/
├── app/
├── package.json
├── SaaS-OS-Free-v1.0/

Rules:
- Treat SaaS OS as a vendor system.
- Do not modify contract files.
- Do not edit tokens.

---

## 2) Import Tokens Globally (2 min)

Import the token CSS file.

Example (App Router):

In app/globals.css:

@import "../SaaS-OS-Free-v1.0/tokens-export/tokens.css";

Hard rule:
Do not hardcode colors or spacing.
Always use token variables.

---

## 3) Use Button + Input Contracts

Before generating code, read:

SaaS-OS-Free-v1.0/docs/engineering/contracts/ui-button.md  
SaaS-OS-Free-v1.0/docs/engineering/contracts/ui-input.md  

These are authoritative.

Cursor must not:
- Add new variants
- Add new states
- Add implicit logic
- Redefine component meaning

If something is not in the contract, it does not exist.

---

## 4) Open the Project in Cursor

Open the project root (not the SaaS OS folder alone).

When prompting Cursor:

- Reference the Button or Input contract explicitly
- Use tokens only
- Keep instructions narrow and specific

Example prompt:

Read:
- SaaS-OS-Free-v1.0/docs/engineering/contracts/ui-button.md

Modify app/page.tsx:

Create a simple landing page that:
- Uses SaaS OS token variables
- Includes one primary Button
- Includes one Input field
- Does not add new states or variants
- Does not invent behavior

If contract information is missing, stop.

---

## 5) Validate Output

After Cursor generates code:

Check:

- No hardcoded values
- No extra props
- No implicit states
- Tokens used correctly

If violations exist:
1. Reject output
2. Tighten the prompt
3. Regenerate

Manual patching hides systemic problems.

---

## 6) Run the App

npm run dev

Confirm:
- Page renders
- Button renders correctly
- Input renders correctly
- Styling uses token values

---

## Done

You now have:

- Token-aligned styling
- Contract-compliant components
- A clean generation loop

Free Edition supports structured UI building.

Advanced flows, state systems, and full architecture are available in SaaS OS Pro.